ServerEvents.recipes(event => {

	let objectreg=/[a-z_]*:[a-z_/]*/ //物品的正则表达式
	let tagreg=/#[a-z_]*:[a-z_/]*/ //tag的正则表达式
	let oddreg=/[0-9.][0-9.]*%/ //概率修饰的正则表达式
	let cntreg=/[0-9.][0-9.]*x/ //数量修饰的正则表达式
	let numreg=/[0-9.]*/ //数字正则表达式
	function cutting(material,tool,results){
		if(!Array.isArray(results))results=[results]//把独立的results转化为列表
		
		let rcobj={type: 'farmersdelight:cutting',ingredients: [],tool:{},result:[]} //配方的Object
		//如果材料是tag，就记作tag
		if(tagreg.test(material))rcobj.ingredients.push({"tag":objectreg.exec(material)[0]})
		else rcobj.ingredients.push({"item":objectreg.exec(material)[0]})
		//如果工具是tag，就记作tag
		if(tagreg.test(tool))rcobj.tool.tag=objectreg.exec(tool)[0]
		else rcobj.tool.item=objectreg.exec(tool)[0]
		//遍历所有结果
		for(let i=0;i<results.length;i++){
			let reobj={}
			//如果条目里面没有物品，就跳过
			if(!objectreg.test(results[i]))continue;
			//如果有概率修饰就加上概率
			if(oddreg.test(results[i]))reobj.chance=parseFloat(numreg.exec(oddreg.exec(results[i])[0])[0])/100.0
			//如果有数量修饰就加上数量
			if(cntreg.test(results[i]))reobj.count=parseInt(numreg.exec(cntreg.exec(results[i])[0])[0])
			reobj.item=objectreg.exec(results[i])[0]
			rcobj.result.push(reobj)
		}
		//event.custom可以直接以json形式注册任何配方
		event.custom(rcobj)
	}

	function cooking(ingredients,result,container,time,exp,booktab){
		if(!Array.isArray(ingredients))ingredients=[ingredients]
		if(time==null)time=100;
		if(exp==null)exp=0.35;
		if(booktab==null)booktab="misc";
		let rcobj={type:'farmersdelight:cooking',ingredients:[],result:{},
			recipe_book_tab:booktab,cookingtime:time,experience:exp}

		//if(container!=null&&container!="minecraft:air"){
		if(container!=null){
			rcobj.container={"item":objectreg.exec(container)[0]};
		}

		let reobj={}
		if(cntreg.test(result))reobj.count=parseInt(numreg.exec(cntreg.exec(result)[0])[0])
		reobj.item=objectreg.exec(result)[0]
		rcobj.result=reobj

		for(let i=0;i<ingredients.length;i++){
			if(Array.isArray(ingredients[i])){
				let inlst=[];
				for(let j=0;j<ingredients[i].length;j++){
					if(!objectreg.test(ingredients[i][j]))continue;
					if(tagreg.test(ingredients[i][j]))inlst.push({"tag":objectreg.exec(ingredients[i][j])[0]})
					else inlst.push({"item":objectreg.exec(ingredients[i][j])[0]})
				}
				rcobj.ingredients.push(inlst)
				continue;
			}
			let inobj={}
			if(!objectreg.test(ingredients[i]))continue;
			if(tagreg.test(ingredients[i]))inobj.tag=objectreg.exec(ingredients[i])[0]
			else inobj.item=objectreg.exec(ingredients[i])[0]
			if(cntreg.test(ingredients[i])){
				let tmp=parseInt(numreg.exec(cntreg.exec(ingredients[i])[0])[0])
				for(let j=0;j<tmp;j++)rcobj.ingredients.push(inobj)
				continue;
			}
			rcobj.ingredients.push(inobj)
		}
		return event.custom(rcobj)
	}
	//pizzacraft
	event.remove({mod:'pizzacraft',not:{output:'#pizzacraft:keeprecipe'}})
	event.smithing(
		'pizzacraft:diamond_pizza_peel',
		'create:sand_paper',
		'pizzacraft:iron_pizza_peel',
		'minecraft:diamond'
	)
	event.shaped(
		Item.of('pizzacraft:iron_pizza_peel'),
		[
			'A  ',
			'B  ',
			'B  '
		],
		{
				A: 'minecraft:heavy_weighted_pressure_plate',
				B: 'minecraft:stick'
			}
	)
	event.shaped(
		Item.of('pizzacraft:golden_pizza_peel'),
		[
			'A  ',
			'B  ',
			'B  '
		],
		{
				A: 'minecraft:light_weighted_pressure_plate',
				B: 'minecraft:stick'
			}
	)
	event.shaped(
		Item.of('pizzacraft:stone_pizza_peel'),
		[
			'A  ',
			'B  ',
			'B  '
		],
		{
				A: 'minecraft:stone_pressure_plate',
				B: 'minecraft:stick'
			}
	)
	event.shapeless(
		Item.of('pizzacraft:dough', 2),
		['2x minecraft:wheat',
		'#forge:eggs',
		'farmersdelight:milk_bottle'])
	event.custom({
		type: "create:mixing",
		ingredients: [
		{tag: "forge:flour"},
		{tag: "forge:flour"},
		{tag: "forge:eggs"},
		{amount: 250,fluid: "minecraft:milk",nbt: {}}
		],
		results: [{
		  item: "pizzacraft:dough",
		  count: 4
		}]
	})
	event.shaped(
		Item.of('pizzacraft:oven'),
		[
			'AAA',
			'BCB',
			'BBB'
		],
		{
				A: 'minecraft:smooth_stone',
				B: 'minecraft:bricks',
				C: 'minecraft:campfire'
			}
	)
	//chapter 1
	cutting('minecraft:brown_mushroom','#forge:tools/knives',['2x kubejs:sliced_brown_mushroom'])
	event.smoking('kubejs:smoked_brown_mushroom', 'kubejs:sliced_brown_mushroom')
	cutting('minecraft:red_mushroom','#forge:tools/knives',['2x kubejs:sliced_red_mushroom'])
	event.smoking('kubejs:smoked_red_mushroom', 'kubejs:sliced_red_mushroom')
	cooking(["minecraft:egg","minecraft:egg","youkaishomecoming:butter","vintagedelight:salt_dust"],"kubejs:mayo_sauce","minecraft:bowl")
	cooking(["farmersdelight:onion","farmersdelight:tomato","minecraft:sugar","vintagedelight:salt_dust"],"kubejs:bbq_sauce","minecraft:bowl")

	event.recipes.create.mixing([Fluid.of("kubejs:bbq_sauce").withAmount(250)],["farmersdelight:onion","farmersdelight:tomato","minecraft:sugar","vintagedelight:salt_dust"])
	event.recipes.create.filling("kubejs:bbq_sauce",["minecraft:bowl",Fluid.of("kubejs:bbq_sauce").withAmount(250)])
	event.recipes.create.emptying(["minecraft:bowl",Fluid.of("kubejs:bbq_sauce").withAmount(250)],"kubejs:bbq_sauce")

	cooking(["minecraft:potato","youkaishomecoming:butter"],"kubejs:hashbrown")
	event.smoking('kubejs:smoked_carrot', 'minecraft:carrot')
	cutting('kubejs:smoked_carrot','#forge:tools/knives',['2x kubejs:smoked_carrot_slice'])
	cutting('farmersdelight:cooked_mutton_chops','#forge:tools/knives',['kubejs:boneless_mutton','minecraft:bone_meal'])
	event.remove({ id: 'farmersdelight:cutting/smoked_ham' })
	cutting('farmersdelight:smoked_ham','#forge:tools/knives',['3x kubejs:sliced_ham','minecraft:bone'])
	cutting('vintagedelight:cheese_slice','#forge:tools/knives',['4x kubejs:cheese_slice'])
	event.custom({type: "vintagedelight:fermenting",
	processingTime: 5000,
	ingredients: [
    {item: "kubejs:bamboo_shoot"},
    {item: "kubejs:bamboo_shoot"},
	{item: "kubejs:bamboo_shoot"},
	{item: "kubejs:bamboo_shoot"},
	{item: "kubejs:bamboo_shoot"},
    {tag: "forge:salt"}],
	"output": {
	"count": 5,"item": "kubejs:pickled_bamboo_shoot"}
	})
	cutting('kubejs:pickled_bamboo_shoot','#forge:tools/knives',['2x kubejs:sliced_bamboo_shoot'])
	cutting('vintagedelight:pickled_onion','#forge:tools/knives',['2x kubejs:onion_slice'])
	cutting('vintagedelight:pickled_beetroot','#forge:tools/knives',['2x kubejs:beetroot_slice'])
	
	//chapter 2
	cutting('crabbersdelight:cooked_clawster','#forge:tools/knives',['3x kubejs:clawster_slice'])
	cutting('crabbersdelight:raw_clam_meat','#forge:tools/knives',['4x kubejs:clam_slice'])
	cutting('collectorsreap:clam_meat','#forge:tools/knives',['kubejs:clam_slice'])
	cooking(['crabbersdelight:cooked_crab','#forge:dough'],'3x kubejs:crab_slice')
	cutting('collectorsreap:cooked_tiger_prawn','#forge:tools/knives',['2x kubejs:shrimp_slice'])
	cutting('crabbersdelight:cooked_shrimp','#forge:tools/knives',['3x kubejs:shrimp_slice'])
	cooking(["collectorsreap:uni","collectorsreap:uni","minecraft:dried_kelp","vintagedelight:salt_dust"],"kubejs:urchin_sauce","minecraft:bowl")
	event.recipes.create.mixing([Fluid.of("kubejs:urchin_sauce").withAmount(250)],["collectorsreap:uni","collectorsreap:uni","minecraft:dried_kelp","vintagedelight:salt_dust"])
	event.recipes.create.filling("kubejs:urchin_sauce",["minecraft:bowl",Fluid.of("kubejs:urchin_sauce").withAmount(250)])
	event.recipes.create.emptying(["minecraft:bowl",Fluid.of("kubejs:urchin_sauce").withAmount(250)],"kubejs:urchin_sauce")
	cooking(["#forge:raw_fishes","#forge:raw_fishes","farmersdelight:onion","minecraft:sugar"],"kubejs:seafood_sauce","minecraft:bowl")
	event.recipes.create.mixing([Fluid.of("kubejs:seafood_sauce").withAmount(250)],["#forge:raw_fishes","#forge:raw_fishes","farmersdelight:onion","minecraft:sugar"])
	event.recipes.create.filling("kubejs:seafood_sauce",["minecraft:bowl",Fluid.of("kubejs:seafood_sauce").withAmount(250)])
	event.recipes.create.emptying(["minecraft:bowl",Fluid.of("kubejs:seafood_sauce").withAmount(250)],"kubejs:seafood_sauce")
	//chapter 3
	event.campfireCooking('kubejs:fried_turtle_eggs', 'minecraft:turtle_egg')
	cutting('vintagedelight:pickle','#forge:tools/knives',['2x kubejs:sliced_pickle'])
	cutting('vintagedelight:pickled_pepper','#forge:tools/knives',['2x kubejs:pepper_pieces'])
	cutting('dropthemeat:cooked_goat','#forge:tools/knives',['2x kubejs:sliced_goat'])
	cutting('dropthemeat:cooked_turtle','#forge:tools/knives',['2x kubejs:sliced_turtle'])
	cooking(["vintagedelight:ghost_pepper","vintagedelight:ghost_pepper","farmersdelight:minced_beef","farmersdelight:onion"],"kubejs:pepper_sauce","minecraft:bowl")
	event.recipes.create.mixing([Fluid.of("kubejs:pepper_sauce").withAmount(250)],["vintagedelight:ghost_pepper","vintagedelight:ghost_pepper","farmersdelight:minced_beef","farmersdelight:onion"])
	event.recipes.create.filling("kubejs:pepper_sauce",["minecraft:bowl",Fluid.of("kubejs:pepper_sauce").withAmount(250)])
	event.recipes.create.emptying(["minecraft:bowl",Fluid.of("kubejs:pepper_sauce").withAmount(250)],"kubejs:pepper_sauce")
	cooking(["collectorsreap:lime_slice","collectorsreap:lime_slice","minecraft:honey_bottle"],"kubejs:lime_sauce","minecraft:bowl")
	event.recipes.create.mixing([Fluid.of("kubejs:lime_sauce").withAmount(250)],["collectorsreap:lime_slice","collectorsreap:lime_slice",Fluid.of("create:honey").withAmount(250)])
	event.recipes.create.filling("kubejs:lime_sauce",["minecraft:bowl",Fluid.of("kubejs:lime_sauce").withAmount(250)])
	event.recipes.create.emptying(["minecraft:bowl",Fluid.of("kubejs:lime_sauce").withAmount(250)],"kubejs:lime_sauce")
	//chapter 4
	
	cutting('minecraft:crimson_fungus','#forge:tools/knives',['2x kubejs:sliced_crimson_fungus'])
	event.smoking('kubejs:smoked_crimson_fungus', 'kubejs:sliced_crimson_fungus')
	cutting('minecraft:warped_fungus','#forge:tools/knives',['2x kubejs:sliced_warped_fungus'])
	event.smoking('kubejs:smoked_warped_fungus', 'kubejs:sliced_warped_fungus')
	
	cooking(["mynethersdelight:bullet_pepper","mynethersdelight:bullet_pepper","minecraft:blaze_powder","mynethersdelight:minced_strider"],"kubejs:blaze_sauce","minecraft:bowl")
	event.recipes.create.mixing([Fluid.of("kubejs:blaze_sauce").withAmount(250)],["mynethersdelight:bullet_pepper","mynethersdelight:bullet_pepper","minecraft:blaze_powder","mynethersdelight:minced_strider"])
	event.recipes.create.filling("kubejs:blaze_sauce",["minecraft:bowl",Fluid.of("kubejs:blaze_sauce").withAmount(250)])
	event.recipes.create.emptying(["minecraft:bowl",Fluid.of("kubejs:blaze_sauce").withAmount(250)],"kubejs:blaze_sauce")
	cooking(["collectorsreap:pomegranate_slice","collectorsreap:pomegranate_slice","minecraft:honey_bottle"],"kubejs:pomegranate_sauce","minecraft:bowl")
	event.recipes.create.mixing([Fluid.of("kubejs:pomegranate_sauce").withAmount(250)],["collectorsreap:pomegranate_slice","collectorsreap:pomegranate_slice",Fluid.of("create:honey").withAmount(250)])
	event.recipes.create.filling("kubejs:pomegranate_sauce",["minecraft:bowl",Fluid.of("kubejs:pomegranate_sauce").withAmount(250)])
	event.recipes.create.emptying(["minecraft:bowl",Fluid.of("kubejs:pomegranate_sauce").withAmount(250)],"kubejs:pomegranate_sauce")
	cutting('ends_delight:chorus_succulent','#forge:tools/knives',['2x kubejs:sliced_succulent'])
	
	//chapter 5
	cutting('minecraft:pitcher_plant','#forge:tools/knives',['4x kubejs:sliced_pitcher',"minecraft:pitcher_pod",'50% minecraft:pitcher_pod'])
	cutting('minecraft:torchflower','#forge:tools/knives',['2x kubejs:sliced_torchflower','minecraft:torchflower_seeds',"50% minecraft:torchflower_seeds"])
	cutting('youkaishomecoming:udumbara_flower','#forge:tools/knives',['8x kubejs:sliced_udumbera'])
	cutting('quark:ancient_fruit','#forge:tools/knives',['2x kubejs:sliced_enchantfruit'])
	cutting('snifferplus:fiddlefern','#forge:tools/knives',['2x kubejs:fiddlefern'])
	cutting('dropthemeat:cooked_sniffer','#forge:tools/knives',['12x kubejs:sliced_sniffer'])
	cutting('vintagedelight:century_egg','#forge:tools/knives',['16x kubejs:sliced_century_egg'])
	cooking(["minecraft:sniffer_egg","youkaishomecoming:butter","vintagedelight:salt_dust"],"12x kubejs:scrambled_snifferegg")
	cooking(["kubejs:sliced_pitcher","kubejs:sliced_pitcher","kubejs:sliced_torchflower",'quark:ancient_fruit',"minecraft:honey_bottle"],"kubejs:ancient_sauce","minecraft:bowl")
	event.recipes.create.mixing([Fluid.of("kubejs:ancient_sauce").withAmount(250)],["kubejs:sliced_pitcher","kubejs:sliced_pitcher","kubejs:sliced_torchflower",'quark:ancient_fruit',Fluid.of("create:honey").withAmount(250)])
	event.recipes.create.filling("kubejs:ancient_sauce",["minecraft:bowl",Fluid.of("kubejs:ancient_sauce").withAmount(250)])
	event.recipes.create.emptying(["minecraft:bowl",Fluid.of("kubejs:ancient_sauce").withAmount(250)],"kubejs:ancient_sauce")

	event.remove({ output: 'some_assembly_required:burger_bun' })
	event.remove({ id: 'resourceful_tools:blaze_rod' })
	event.shapeless(
	Item.of('some_assembly_required:burger_bun', 2),
	['2x minecraft:wheat',
	'minecraft:wheat_seeds'])
	event.remove({ id: 'minecraft:barrel' })
	event.remove({ id: 'minecraft:cartography_table' })
	event.remove({ id: 'minecraft:brewing_stand' })
	event.shaped(
	Item.of('minecraft:barrel', 1),
	[
		'ACA',
		'CBC',
		'ACA'
	],
	{
			A: '#minecraft:planks',
			B: 'kubejs:copper_certificate',
			C: 'kubejs:iron_coin'
		}
	)
	event.shaped(
	Item.of('minecraft:cartography_table', 1),
	[
		'ACA',
		'CBC',
		'ACA'
	],
	{
			A: '#minecraft:planks',
			B: 'kubejs:iron_certificate',
			C: 'kubejs:gold_coin'
		}
	)
	event.shaped(
	Item.of('minecraft:brewing_stand', 1),
	[
		'CAC',
		'CBC',
		'AAA'
	],
	{
			A: 'minecraft:cobblestone',
			B: 'kubejs:gold_certificate',
			C: 'kubejs:diamond_coin'
		}
	)
	event.recipes.create.mixing('2x kubejs:crushed_brass',["create:crushed_raw_copper","create:crushed_raw_zinc"])
	event.blasting("create:brass_ingot","kubejs:crushed_brass")
	event.recipes.create.compacting("minecraft:blaze_rod",["4x minecraft:blaze_powder",Fluid.lava(100)])
	event.shaped(
	Item.of('create:blaze_burner', 1),
	[
		' A ',
		'ABA',
		' A '
	],
	{
			A: 'minecraft:blaze_rod',
			B: 'create:empty_blaze_burner'
		}
	)
	event.remove({ id: 'fishermens_trap:fishtrap_farmersdelight' })
	event.remove({ id: 'crabbersdelight:crab_trap' })
	event.remove({ id: 'minecraft:fishing_rod' })
	event.shaped(
	Item.of('kubejs:string_duper', 1),
	[
		'CDC',
		'ABA',
		'CCC'
	],
	{
			A: 'minecraft:tripwire_hook',
			B: 'minecraft:string',
			C: '#minecraft:planks',
			D: 'minecraft:water_bucket'
		}
	)
	event.smoking("minecraft:sugar","minecraft:beetroot")
	event.blasting("minecraft:coal","minecraft:charcoal")
	event.blasting("minecraft:glowstone_dust","minecraft:redstone")
	/*
	event.shaped(
	Item.of('kubejs:burgerbot_iron', 1),
	[
		'CAC',
		'ABA',
		'CAC'
	],
	{
			A: 'kubejs:gold_coin',
			B: 'kubejs:iron_certificate',
			C: 'minecraft:iron_block'
		}
	)
	event.shaped(
	Item.of('kubejs:burgerbot_gold', 1),
	[
		'CAC',
		'ABA',
		'CDC'
	],
	{
			A: 'kubejs:diamond_coin',
			B: 'kubejs:gold_certificate',
			C: 'minecraft:gold_block',
			D: 'kubejs:burgerbot_iron'
		}
	)
	*/
	event.shapeless(
	Item.of('kubejs:copper_certificate', 1),
	['kubejs:iron_certificate']
	)
	event.shapeless(
	Item.of('kubejs:iron_certificate', 1),
	['kubejs:gold_certificate']
	)
	event.shapeless(
	Item.of('kubejs:gold_certificate', 1),
	['kubejs:diamond_certificate']
	)
	event.shapeless(
	Item.of('kubejs:diamond_certificate', 1),
	['kubejs:netherite_certificate']
	)

	let coin_list=['kubejs:copper_coin','kubejs:iron_coin','kubejs:gold_coin'
		,'kubejs:diamond_coin','kubejs:netherite_coin']
	for(let i=0;i<=3;i++){
		event.shapeless(
		Item.of(coin_list[i], 10),
		[coin_list[i+1]]
		)
		event.recipes.create.compacting(coin_list[i+1],`10x ${coin_list[i]}`)
	}

	/*
	event.custom({type: 'farmersdelight:cutting',
	ingredients: [{ item: 'mynethersdelight:powder_cannon' }],
	tool: { item: 'minecraft:grindstone' },
	result: [{ item: 'create:cinder_flour'}]
	})
	*/
	event.recipes.create.milling("create:cinder_flour", "mynethersdelight:powder_cannon")
	
	event.shaped(
	Item.of('kubejs:rice_burger', 2),
	[
		'A  ',
		'A  ',
		'   '
	],
	{
		A: 'farmersdelight:cooked_rice'
	}
	)
	cutting('kubejs:rice_burger','#forge:tools/knives',['kubejs:rice_burger_bottom','kubejs:rice_burger_top'])
	cooking(["minecraft:ink_sac","#forge:dough","#forge:seeds"],"2x kubejs:ink_burger")
	cutting('kubejs:ink_burger','#forge:tools/knives',['kubejs:ink_burger_top','kubejs:ink_burger_bottom'])
	cooking(["vintagedelight:oat_dough","minecraft:sugar","#forge:seeds"],"2x kubejs:oat_burger")
	cutting('kubejs:oat_burger','#forge:tools/knives',['kubejs:oat_burger_top','kubejs:oat_burger_bottom'])
	cooking(["create:cinder_flour","minecraft:blaze_powder","minecraft:gunpowder"],"2x kubejs:blaze_burger")
	cutting('kubejs:blaze_burger','#forge:tools/knives',['kubejs:blaze_burger_top','kubejs:blaze_burger_bottom'])
	cooking(["minecraft:sniffer_egg","3x youkaishomecoming:butter","farmersdelight:onion"],"8x kubejs:egg_burger")
	cutting('kubejs:egg_burger','#forge:tools/knives',['kubejs:egg_burger_top','kubejs:egg_burger_bottom'])
	
	event.remove({ output: 'resourceful_tools:hand_tiller' })
	event.remove({ output: 'resourceful_tools:hand_tiller_copper' })
	event.remove({ output: 'automobility:steep_slope' })
	event.remove({ output: 'automobility:slope' })
	
	event.shaped(
	Item.of('kubejs:spade'),
	[
		'  A',
		' B ',
		'C  '
	],
	{
			A: 'minecraft:iron_ingot',
			B: 'minecraft:iron_nugget',
			C: 'minecraft:stick'
		}
	)
	event.recipes.create.haunting("ends_delight:dragon_leg","farmersdelight:ham")
	event.recipes.create.haunting("ends_delight:shulker_meat","crabbersdelight:raw_clam_meat")
	event.recipes.create.haunting("mynethersdelight:ghasta","farmersdelight:raw_pasta")
	cutting('dropthemeat:raw_villager','#forge:tools/knives','youkaishomecoming:flesh')
	
	event.shapeless(
	Item.of('mca:rose_gold_dust', 4),
	['3x create:crushed_raw_gold',
	'create:crushed_raw_copper'])
	
	

	event.smelting('kubejs:caramel', 'minecraft:sugar')
	event.campfireCooking('kubejs:caramel', 'minecraft:sugar')
	event.shaped(
		Item.of('kubejs:soda_can', 16),
		[
			' A ',
			'A A',
			' A '
		],
		{
			A: 'minecraft:iron_nugget'
		}
	)
	event.custom({type: "vintagedelight:fermenting",
		processingTime: 600,
		ingredients: [{item: "kubejs:soda_can"}],
		output: {count: 1,item: "kubejs:soda_water"}
	})
	event.shapeless("kubejs:soda_plain",["kubejs:soda_water","kubejs:caramel","minecraft:sugar"])
	event.shapeless("kubejs:soda_lily",["kubejs:soda_water","kubejs:caramel","minecraft:sugar","minecraft:lily_pad"])
	event.shapeless("kubejs:soda_lime",["kubejs:soda_water","kubejs:caramel","minecraft:sugar","collectorsreap:lime_slice"])
	event.shapeless("kubejs:soda_pomegranate",["kubejs:soda_water","kubejs:caramel","minecraft:sugar","collectorsreap:pomegranate_slice"])
	event.shapeless("kubejs:soda_ancient",["kubejs:soda_water","kubejs:caramel","minecraft:sugar","quark:ancient_fruit"])
	cooking(["minecraft:potato","vintagedelight:salt_dust","youkaishomecoming:butter"],"kubejs:fries","minecraft:paper")
	cooking(["#forge:raw_chicken","vintagedelight:salt_dust","youkaishomecoming:butter"],"kubejs:fried_chicken","minecraft:paper")

	cooking(["farmersdelight:tomato","farmersdelight:tomato","farmersdelight:onion","vintagedelight:salt_dust"],"kubejs:pizza_sauce_tomato","minecraft:bowl")
	event.recipes.create.mixing([Fluid.of("kubejs:pizza_sauce_tomato").withAmount(250)],["farmersdelight:tomato","farmersdelight:tomato","farmersdelight:onion","vintagedelight:salt_dust"])
	event.recipes.create.filling("kubejs:pizza_sauce_tomato",["minecraft:bowl",Fluid.of("kubejs:pizza_sauce_tomato").withAmount(250)])
	event.recipes.create.emptying(["minecraft:bowl",Fluid.of("kubejs:pizza_sauce_tomato").withAmount(250)],"kubejs:pizza_sauce_tomato")

	cooking(["youkaishomecoming:butter","#forge:raw_fishes","#forge:raw_fishes","vintagedelight:salt_dust"],"kubejs:pizza_sauce_seafood","minecraft:bowl")
	event.recipes.create.mixing([Fluid.of("kubejs:pizza_sauce_seafood").withAmount(250)],["youkaishomecoming:butter","#forge:raw_fishes","#forge:raw_fishes","vintagedelight:salt_dust"])
	event.recipes.create.filling("kubejs:pizza_sauce_seafood",["minecraft:bowl",Fluid.of("kubejs:pizza_sauce_seafood").withAmount(250)])
	event.recipes.create.emptying(["minecraft:bowl",Fluid.of("kubejs:pizza_sauce_seafood").withAmount(250)],"kubejs:pizza_sauce_seafood")

	cooking(["vintagedelight:ghost_charcoal","youkaishomecoming:butter","youkaishomecoming:butter","vintagedelight:salt_dust"],"kubejs:pizza_sauce_alfredo","minecraft:bowl")
	event.recipes.create.mixing([Fluid.of("kubejs:pizza_sauce_alfredo").withAmount(250)],["vintagedelight:ghost_charcoal","youkaishomecoming:butter","youkaishomecoming:butter","vintagedelight:salt_dust"])
	event.recipes.create.filling("kubejs:pizza_sauce_alfredo",["minecraft:bowl",Fluid.of("kubejs:pizza_sauce_alfredo").withAmount(250)])
	event.recipes.create.emptying(["minecraft:bowl",Fluid.of("kubejs:pizza_sauce_alfredo").withAmount(250)],"kubejs:pizza_sauce_alfredo")

	cooking(["minecraft:crimson_fungus","minecraft:crimson_fungus","mynethersdelight:bullet_pepper","minecraft:blaze_powder"],"kubejs:pizza_sauce_blaze","minecraft:bowl")
	event.recipes.create.mixing([Fluid.of("kubejs:pizza_sauce_blaze").withAmount(250)],["minecraft:crimson_fungus","minecraft:crimson_fungus","mynethersdelight:bullet_pepper","minecraft:blaze_powder"])
	event.recipes.create.filling("kubejs:pizza_sauce_blaze",["minecraft:bowl",Fluid.of("kubejs:pizza_sauce_blaze").withAmount(250)])
	event.recipes.create.emptying(["minecraft:bowl",Fluid.of("kubejs:pizza_sauce_blaze").withAmount(250)],"kubejs:pizza_sauce_blaze")

	cooking(["kubejs:sliced_torchflower","kubejs:sliced_torchflower","kubejs:fiddlefern","minecraft:blaze_powder"],"kubejs:pizza_sauce_torch","minecraft:bowl")
	event.recipes.create.mixing([Fluid.of("kubejs:pizza_sauce_torch").withAmount(250)],["kubejs:sliced_torchflower","kubejs:sliced_torchflower","kubejs:fiddlefern","minecraft:blaze_powder"])
	event.recipes.create.filling("kubejs:pizza_sauce_torch",["minecraft:bowl",Fluid.of("kubejs:pizza_sauce_torch").withAmount(250)])
	event.recipes.create.emptying(["minecraft:bowl",Fluid.of("kubejs:pizza_sauce_torch").withAmount(250)],"kubejs:pizza_sauce_torch")
	event.shaped(
		Item.of('kubejs:broom'),
		[
			'  A',
			' B ',
			'C  '
		],
		{
				A: 'minecraft:hay_block',
				B: 'farmersdelight:rope',
				C: 'minecraft:stick'
			}
		)
	event.shaped(
		Item.of('kubejs:baggage'),
		[
			'  A',
			' BD',
			'C  '
		],
		{
				D: 'farmersdelight:canvas',
				B: 'minecraft:bread',
				A: 'minecraft:gold_nugget',
				C: 'minecraft:stick'
			}
		)
	event.shaped(
		Item.of('kubejs:iron_contract'),
		[
			'ABA',
			'CDC',
			'ABA'
		],
		{
			A:'minecraft:iron_block',
			B:'kubejs:gold_coin',
			C:'minecraft:paper',
			D:'kubejs:iron_certificate'
		}
	)
	event.shaped(
		Item.of('kubejs:gold_contract'),
		[
			'ABA',
			'CDC',
			'ABA'
		],
		{
			A:'minecraft:gold_block',
			B:'kubejs:diamond_coin',
			C:'minecraft:paper',
			D:'kubejs:gold_certificate'
		}
	)
	event.shaped(
		Item.of('kubejs:diamond_contract'),
		[
			'ABA',
			'CDC',
			'ABA'
		],
		{
			A:'minecraft:diamond_block',
			B:'kubejs:netherite_coin',
			C:'minecraft:paper',
			D:'kubejs:netherite_certificate'
		}
	)
	event.shaped(
		Item.of('kubejs:counter'),
		[
			'AAA',
			'BCB',
			'DDD'
		],
		{
			A:'minecraft:iron_trapdoor',
			B:'#minecraft:planks',
			C:'kubejs:diamond_certificate',
			D:'kubejs:netherite_coin'
		}
	)
	event.shaped(
		Item.of('create:item_vault'),
		[
			'A  ',
			'B  ',
			'A  '
		],
		{
			A:'create:iron_sheet',
			B:'minecraft:composter'
		}
	)
	event.shaped(
		Item.of('create:fluid_tank'),
		[
			'A  ',
			'B  ',
			'A  '
		],
		{
			A:'create:copper_sheet',
			B:'minecraft:composter'
		}
	)
	event.shapeless("kubejs:newspaper",["resourceful_tools:ream_of_paper","minecraft:black_dye","minecraft:feather"])


	event.shaped(
		Item.of("kubejs:waterspring"),
		[
			"AAA",
			"BCB",
			"AAA"
		],
		{
			A:"create:brass_sheet",
			B:"create:brass_nugget",
			C:"resourceful_tools:wellspring"
		}
	)
	event.shaped(
		Item.of("kubejs:lavaspring"),
		[
			"AAA",
			"BCB",
			"AAA"
		],
		{
			A:"create:brass_sheet",
			B:"create:brass_nugget",
			C:"resourceful_tools:lavaspring"
		}
	)
	event.shaped(
		Item.of("kubejs:magic_sand"),
		[
			"ABA",
			"BCB",
			"ABA"
		],
		{
			A:"collectorsreap:lunar_pearl",
			B:"mca:rose_gold_dust",
			C:"minecraft:sand"
		}
	)
	event.remove({output:"youkaishomecoming:moon_lantern"})
	event.shaped(
		Item.of("kubejs:mini_banker"),
		[
			" A ",
			" B ",
			" C "
		],
		{
			A:"minecraft:black_carpet",
			B:"minecraft:carved_pumpkin",
			C:"minecraft:black_wool"
		}
	)
	event.shapeless(
		"kubejs:bank_card",["create:iron_sheet","minecraft:yellow_dye","minecraft:black_dye"]
	)
	
	cooking(["create:cinder_flour","#forge:mushrooms"],"minecraft:nether_wart")
	cooking(["minecraft:pitcher_pod","kubejs:scrambled_snifferegg","kubejs:sliced_torchflower",'youkaishomecoming:butter'],"kubejs:stuffed_pitcher_pod")
	//butter crap
	event.remove({id:"youkaishomecoming:mixing/mayonnaise_bottle"})
	event.recipes.create.mixing([Fluid.of("youkaishomecoming:mayonnaise").withAmount(250)],["youkaishomecoming:butter","minecraft:egg","minecraft:egg","vintagedelight:salt_dust"])
	event.recipes.create.filling("kubejs:mayo_sauce",[Fluid.of("youkaishomecoming:mayonnaise").withAmount(250),"minecraft:bowl"])
	event.recipes.create.emptying([Fluid.of("youkaishomecoming:mayonnaise").withAmount(250),"minecraft:bowl"],"kubejs:mayo_sauce")
	event.remove({id:"youkaishomecoming:mixing/bowl_of_cream"})
	event.recipes.create.mixing([Fluid.of("youkaishomecoming:cream").withAmount(250)],[Fluid.of('minecraft:milk').withAmount(250)])
	event.recipes.create.compacting(["youkaishomecoming:butter"],[Fluid.of("youkaishomecoming:cream").withAmount(250)])
	event.remove({id:'youkaishomecoming:mixing/butter'})
	event.remove({id:'youkaishomecoming:butter'})
	cooking(["farmersdelight:milk_bottle"],"youkaishomecoming:butter")
	cooking(["minecraft:milk_bucket"],"4x youkaishomecoming:butter")
	event.recipes.create.mixing([Fluid.of("kubejs:ender_sauce").withAmount(250)],["ends_delight:chorus_succulent",["ends_delight:chorus_fruit_grain","minecraft:chorus_fruit"]])
	event.recipes.create.filling("ends_delight:ender_sauce",["minecraft:bowl",Fluid.of("kubejs:ender_sauce").withAmount(250)])
	event.recipes.create.emptying(["minecraft:bowl",Fluid.of("kubejs:ender_sauce").withAmount(250)],"ends_delight:ender_sauce")
	
})